% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{getSample}
\alias{getSample}
\alias{getSample,Project,character-method}
\title{Extract samples}
\usage{
getSample(.Object, sampleName)

\S4method{getSample}{Project,character}(.Object, sampleName)
}
\arguments{
\item{.Object}{An object of Project class}

\item{sampleName}{character the name of the sample}
}
\value{
data.table one row data table with the sample associated metadata
}
\description{
This method extracts the samples
}
\section{Methods (by class)}{
\itemize{
\item \code{getSample(.Object = Project, sampleName = character)}: extracts the sample from the \code{"\linkS4class{Project}"} object

}}
\examples{
projectConfig = system.file(
"extdata",
"example_peps-master",
"example_basic",
"project_config.yaml",
package = "pepr"
)
p = Project(projectConfig)
sampleName = "frog_1"
getSample(p, sampleName)
}
