% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_options.R
\name{mm_algorithm_options}
\alias{mm_algorithm_options}
\title{MM-Algorithm to Compute Penalized Elastic Net S- and M-Estimates}
\usage{
mm_algorithm_options(
  max_it = 500,
  tightening = c("adaptive", "exponential", "none"),
  tightening_steps = 2,
  en_algorithm_opts
)
}
\arguments{
\item{max_it}{maximum number of iterations.}

\item{tightening}{how to make inner iterations more precise as the algorithm
approaches a local minimum.}

\item{tightening_steps}{for \emph{adaptive} tightening strategy, how often to
tighten until the desired tolerance is attained.}

\item{en_algorithm_opts}{options for the inner LS-EN algorithm.
See \link{en_algorithm_options} for details.}
}
\value{
options for the MM algorithm.
}
\description{
Additional options for the MM algorithm to compute EN S- and M-estimates.
}
\seealso{
cd_algorithm_options for a direct optimization of the non-convex
PENSE loss.

Other Robust EN algorithms: 
\code{\link{cd_algorithm_options}()}
}
\concept{Robust EN algorithms}
