% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\docType{class}
\name{penfa-class}
\alias{penfa-class}
\title{S4 Class for describing a \code{penfa} model}
\description{
The \code{penfa} class represents a (fitted) penalized factor
analysis model. It contains a description of the model as specified by the
user, a summary of the data, an internal matrix representation, the
fitting results, and the penalized quantities.
}
\section{Objects from the Class}{


Objects can be created via the \code{\link{penfa}} function.
}

\section{Slots}{


\describe{
\item{\code{version}:}{The \code{penfa} package version used to create this object.}
\item{\code{call}:}{The function call as returned by \code{match.call()}.}
\item{\code{timing}:}{The elapsed time (user + system) for various parts of
the program as a list, including the total time.}
\item{\code{Options}:}{Named list of options that were provided by the user
or filled-in automatically. See \code{\link{penfaOptions}} for additional
details.}
\item{\code{ParTable}:}{Named list describing the model parameters.
Can be coerced to a data.frame. This is also called "parameter table".
It includes information on the fixed, free and penalized parameters, their
indices, the active penalization strategies ("none", "shrink", "diff", or
"shrink + diff"), the starting values, the estimated parameters and the
associated standard errors.}
\item{\code{pta}:}{Named list containing parameter table attributes, like
observed and latent variable names, their indices, and the number of groups.}
\item{\code{Data}:}{Object of internal class \code{"penfaData"}; contains
information about the data set. See the \code{\linkS4class{penfaData}} class
for additional details.}
\item{\code{SampleStats}:}{Object of internal class \code{"penfaSampleStats"};
contains the sample statistics. See the \code{\linkS4class{penfaSampleStats}}
class for additional details.}
\item{\code{Model}:}{Object of internal class \code{"penfaModel"}: the internal
(matrix) representation of the model. See the \code{\linkS4class{penfaModel}}
class for additional details.}
\item{\code{Optim}:}{List. Information about the optimization process. This
includes the estimated parameters (\code{x}), the number of estimated
parameters (\code{npar}), the number of trust-region iterations
(\code{iterations}), the value of the penalized objective function
(\code{fx.pen}), the value of the unpenalized objective
function (\code{fx.unpen}), the penalized log-likelihood (\code{logl.pen};
this is equal to \code{fx.pen} multiplied by (-1)), the unpenalized
log-likelihood (\code{logl.unpen}; this is equal to \code{fx.unpen} multiplied
by (-1)), the penalized gradient (\code{dx.pen}), the penalized Hessian/Fisher
information matrix (\code{hessian.pen}), the list of control arguments for
the trust-region algorithm (\code{control}), and how many times the
objective function became non-positive definite during the estimation
process (\code{npd}). If penfa was called with the option \code{verbose =
 TRUE}, the following additional arguments coming from the trust-region
function \code{trust} are reported in the \code{Optim} slot: \code{argpath},
\code{argtry}, \code{type}, \code{accept}, \code{radii}, \code{rho},
\code{fx.val}, \code{fx.valtry}, \code{change}, \code{stepnorm}. See the
manual page of \code{trust} from the \code{trust} package for an overview of
these quantities.}
\item{\code{Penalize}:}{Object of internal class \code{"penfaPenalty"}; contains
information about the penalization. See the \code{\linkS4class{penfaPenalty}} for
additional details.}
\item{\code{Implied}:}{List. Model-implied moments (covariance matrix and
mean vector).}
\item{\code{Vcov}:}{List. Information about the covariance matrix (vcov) of
the model parameters. This slot includes the following quantities:  the type
of penalized information matrix used in the model (either Hessian or Fisher;
\code{information}), the vcov matrix of parameters (\code{vcov}), whether
the convergence checks on the penalized gradient and the penalized
information matrix were satisfied (\code{solution}), whether the employed
information matrix was positive-definite (\code{pdef}),  whether the
estimated factor solution was admissible (\code{admissibility}), the
standard errors computed according to the Bayesian result from the
information matrix reported in \code{information} (\code{se}), and the 95\%
confidence intervals (\code{ci}).}
\item{\code{Inference}:}{List. Information on effective degrees of the model
and information criteria for model selection. This slot reports the
following quantities: effective degree of freedom for each parameter
(\code{edf.single}), total edf (\code{edf}), influence matrix
(\code{influence.mat}), generalized information criteria (\code{IC}), such
as AIC and BIC.}
\item{\code{external}:}{List. Empty slot.}
}
}

\section{Methods}{


The following methods are available for an object of class
\code{\linkS4class{penfa}}:

\describe{
\item{show}{\code{signature(object = "penfa")}: Prints a short summary of the
estimation process, including the optimization method, the specified penalty
functions, the convergence status, the number of iterations, the tuning
selection strategy, and the effective degrees of freedom. See the manual page of
\code{show,penfa-method} for details. } \item{summary}{\code{signature(object
= "penfa", header = TRUE, estimates = TRUE, ci = TRUE, level =} \code{ 0.95,
nd = 3L, cutoff = 0.05, extra = TRUE)}: Prints a summary of the model
parameter estimates, and the optimization process. See the manual page of
\code{summary,penfa-method} for details.} \item{coef}{\code{signature(object
= "penfa", type = "free", labels = TRUE)}: Returns the estimates of the
parameters in the model as a named numeric vector. See the manual page of
\code{coef,penfa-method} for details.} \item{fitted}{\code{signature(object =
"penfa", labels = TRUE)}: Returns a list of the model-implied moments (per
group). See the manual page of \code{fitted,penfa-method} for details.}
}
}

\references{
Geminiani, E., Marra, G., & Moustaki, I. (2021). "Single- and
Multiple-Group Penalized Factor Analysis: A Trust-Region Algorithm Approach
with Integrated Automatic Multiple Tuning Parameter Selection."
Psychometrika, 86(1), 65-95. \doi{10.1007/s11336-021-09751-8}
}
\seealso{
\code{\link{penfa}}, \code{\link{penfaParEstim}}
}
