% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-others.R
\docType{data}
\name{terrthreat}
\alias{terrthreat}
\title{Estimates from a Random Item Response Model of External Territorial Threat, 1816-2010}
\format{
A data frame with 14781 observations on the following 10 variables.
\describe{
\item{\code{ccode}}{a Correlates of War state code}
\item{\code{year}}{a year}
\item{\code{lterrthreat}}{an estimate of latent external territorial threat for the state in a given year}
\item{\code{sd}}{the standard deviation of simulated, latent external territorial threat}
\item{\code{lwr}}{a lower bound estimate of simulated, latent external territorial threat}
\item{\code{upr}}{an upper bound estimate of simulated, latent external territorial threat}
\item{\code{m_lterrthreat}}{another estimate of latent external territorial threat for the state in a given year}
\item{\code{m_sd}}{another standard deviation of simulated, latent external territorial threat}
\item{\code{m_lwr}}{another lower bound estimate of simulated, latent external territorial threat}
\item{\code{m_upr}}{another upper bound estimate of simulated, latent external territorial threat}
}
}
\usage{
terrthreat
}
\description{
This is a state-year data set on (latent) estimates of external territorial
threat. Data correspond with a publication in \emph{Journal of Global Security Studies}.
}
\details{
The variables with the prefix of \code{m_} communicate alternate estimates in
which the state-year-level estimate of territorial threat derived from dyadic
data is weighted by the minimum distance between pairs of states. The
pertinent variables without this prefix communicate what I (the author!)
treat as the standard measure of latent, external territorial threat in which
the estimates derived from the dyadic data are weighted by capital distance.
You can see the clear corollaries to other functions and data in this package,
like the kind used in \code{\link[=add_minimum_distance]{add_minimum_distance()}} and \code{\link[=add_capital_distance]{add_capital_distance()}}.

The lower and upper bounds communicate 90\% intervals.
}
\references{
Miller, Steven V. 2022. "A Random Item Response Model of External Territorial
Threat, 1816-2010" \emph{Journal of Global Security Studies} 7(4): ogac012.
}
\keyword{datasets}
