% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{gw_mindist}
\alias{gw_mindist}
\title{The Minimum Distance Between States in the Gleditsch-Ward System, 1886-2019}
\format{
A data frame with 868813 observations on the following 4 variables.
\describe{
\item{\code{gwcode1}}{the Gleditsch-Ward state system code for the first state}
\item{\code{gwcode2}}{the Gleditsch-Ward state system code for the second state}
\item{\code{year}}{the year}
\item{\code{mindist}}{the minimum distance between states on Jan. 1 of the year, in kilometers}
}
}
\usage{
gw_mindist
}
\description{
These are non-directed dyad-year data for the minimum distance between states
in the Gleditsch-Ward state system from 1886 to 2019. The data are generated
from the \pkg{cshapes} package.
}
\details{
Data are automatically generated (by default) as directed dyad-years. I elect
to make them non-directed for space considerations. Making non-directed
dyad-year data into directed dyad-year data isn't too difficult in R. It just
looks weird to see the code that does it.

Previous versions of these data were for the minimum distance as of Dec. 31
of the referent year. These are now Jan. 1. Most of the data I provide
elsewhere in this package are to be understood as the data as they were at
the \emph{start} of the year. \code{\link[=add_minimum_distance]{add_minimum_distance()}} permits greater flexibility
with this option, but only for the remote and augmented version of the data.
Check the documentation of that function for more.
}
\references{
Schvitz, Guy, Luc Girardin, Seraina Ruegger, Nils B. Weidmann, Lars-Erik
Cederman,and Kristian Skrede Gleditsch. 2022. "Mapping The International
System, 1886-2017: The \code{CShapes} 2.0 Dataset." \emph{Journal of Conflict
Resolution}. 66(1): 144-161.

Weidmann, Nils B. and Kristian Skrede Gleditsch. 2010. "Mapping and Measuring
Country Shapes: The \code{cshapes} Package." \emph{The R Journal} 2(1): 18-24
}
\keyword{datasets}
