% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_per_mod.R
\name{plot_per_mod}
\alias{plot_per_mod}
\title{Plotting function for periodic curves model}
\usage{
plot_per_mod(Model, XvarName, Ylab = "Response", Xlab = "Covariate",
  Ylim = NULL, Xlim = NULL, Xmin = NULL, Xmax = NULL, Knots = NULL,
  Title = NULL, Vlines = NULL, Hlines = NULL, Cex.lab = NULL,
  Cex.main = NULL, Cex.axis = NULL, Axes = TRUE, Add = FALSE,
  Col = "black", PlotCI = TRUE, Smooth = FALSE, xLocation = 2)
}
\arguments{
\item{Model}{The built model}

\item{XvarName}{Name of the x variable in the dataset (column name)}

\item{Ylab}{Label on vertical (y) axis}

\item{Xlab}{Label on horizontal (x) axis}

\item{Ylim}{Limits of y axis}

\item{Xlim}{Limits of x axis}

\item{Xmin}{The min X of data to be predicted (if Smooth)}

\item{Xmax}{The max X of data to be predicted (if Smooth)}

\item{Knots}{Locations of knots of the splines}

\item{Title}{Title of the plot}

\item{Vlines}{Where to plot vertical lines}

\item{Hlines}{Where to plot horizontal lines}

\item{Cex.lab}{Character expansion (aka "size of font") for the labels}

\item{Cex.main}{Character expansion for main text}

\item{Cex.axis}{Character expansion for the axis text}

\item{Axes}{Plot axes}

\item{Add}{Add to existing plot}

\item{Col}{Color of the plotted lines}

\item{PlotCI}{Plot confidence intervals}

\item{Smooth}{Make the Xaxis values equidistant (and the curve smoother)}

\item{xLocation}{If smooth FALSE, the location of the x term in model$x[, xLocation]}
}
\description{
Plots graph of periodic curves with confidence intervals.
Data should be included in the model.
}
