% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{convert_pdf}
\alias{convert_pdf}
\title{Convert PDF Tables to format more amenable to analysis}
\usage{
convert_pdf(input_file, output_file = NULL, format = "csv",
  message = TRUE, api_key = Sys.getenv("pdftable_api"))
}
\arguments{
\item{input_file}{The PDF file to be converted}

\item{output_file}{The desired name for the output file}

\item{format}{One of 'csv', 'xlm', 'xlsx-single', 'xlsx-multiple'}

\item{message}{If TRUE, outputs a message that conversion was successful}

\item{api_key}{Your API key (from https://pdftables.com)}
}
\value{
Creates an output file with the converted PDF table
}
\description{
Convert PDF Tables to format more amenable to analysis
}
\examples{
\dontrun{
write.csv(head(iris), file = "test.csv", row.names = FALSE)

# Open test.csv and print as PDF to "test.pdf"

convert_pdf("test.pdf", "test2.csv")
}
}

