% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hard_threshold.R
\name{hard_threshold}
\alias{hard_threshold}
\title{Hard-thresholding operator}
\usage{
hard_threshold(D, thresh)
}
\arguments{
\item{D}{The input data matrix.}

\item{thresh}{The scalar-valued hard-threshold acting on \code{D} such that
\code{D[i, j] = 0} when \code{abs(D[i, j]) < thresh}, and
\code{D[i, j] = D[i, j]} otherwise.}
}
\value{
The hard-thresholded matrix.
}
\description{
\code{hard_threshold()} implements the hard-thresholding operator on a given
matrix \code{D}, making \code{D} sparser: elements of \code{D} whose absolute value are less
than a given threshold \code{thresh} are set to 0, i.e. \eqn{D[|D| < thresh] = 0}.

This is used in the non-convex PCP function \code{\link[=rrmc]{rrmc()}} to provide a non-convex
replacement for the \code{prox_l1()} method used in the convex PCP function
\code{\link[=root_pcp]{root_pcp()}}. It is used to iteratively model the sparse \code{S} matrix with the
help of an adaptive threshold (\code{thresh} changes over the course of
optimization).
}
\examples{
set.seed(42)
D <- matrix(rnorm(25), 5, 5)
S <- hard_threshold(D, thresh = 1)
D
S
}
