% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxDelaunay.R
\name{rel.vert.mid.int}
\alias{rel.vert.mid.int}
\title{The index of the vertex region in a middle interval
that contains a given point}
\usage{
rel.vert.mid.int(p, int, c = 0.5)
}
\arguments{
\item{p}{A 1D point. The vertex region \code{p} resides is to be found.}

\item{int}{A \code{vector} of two real numbers representing an interval.}

\item{c}{A positive real number in \eqn{(0,1)}
parameterizing the center inside \code{int}\eqn{=(a,b)}
with the default \code{c=.5}.
For the interval, \code{int}\eqn{=(a,b)},
the parameterized center is \eqn{M_c=a+c(b-a)}.}
}
\value{
A \code{list} with two elements
\item{rv}{Index of the vertex in the interval \code{int}
whose region contains point, \code{p}.}
\item{int}{The vertices of the interval as a \code{vector}
where position of the vertex corresponds to
the vertex index as \code{int=(rv=1,rv=2)}.}
}
\description{
Returns the index of the vertex
whose region contains point \code{p} in
the interval \code{int}\eqn{=(a,b)=}(vertex 1,vertex 2)
with (parameterized) center \eqn{M_c} associated with
the centrality parameter \eqn{c \in (0,1)};
vertices of interval are labeled as 1 and 2 according to their
order in the interval \code{int}.
If the point, \code{p}, is not inside \code{int},
then the function yields \code{NA} as output.
The corresponding vertex region is the interval \eqn{(a,b)}
as \eqn{(a,M_c)} and \eqn{(M_c,b)}
where \eqn{M_c=a+c(b-a)}.

See also (\insertCite{ceyhan:metrika-2012,ceyhan:revstat-2016;textual}{pcds}).
}
\examples{
\donttest{
c<-.4
a<-0; b<-10; int = c(a,b)

Mc<-centerMc(int,c)

rel.vert.mid.int(6,int,c)

n<-20  #try also n<-40
xr<-range(a,b,Mc)
xf<-(int[2]-int[1])*.5
Xp<-runif(n,a,b)

Rv<-vector()
for (i in 1:n)
  Rv<-c(Rv,rel.vert.mid.int(Xp[i],int,c)$rv)
Rv

jit<-.1
yjit<-runif(n,-jit,jit)

Xlim<-range(a,b,Xp)
xd<-Xlim[2]-Xlim[1]

plot(cbind(Mc,0),main="vertex region indices for the points", xlab=" ",
ylab=" ", xlim=Xlim+xd*c(-.05,.05),ylim=3*range(yjit),pch=".",cex=3)
abline(h=0)
points(Xp,yjit)
abline(v=c(a,b,Mc),lty = 2,col=c(1,1,2))
text(Xp,yjit,labels=factor(Rv))
text(cbind(c(a,b,Mc),.02),c("rv=1","rv=2","Mc"))
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rel.vert.end.int}}
}
\author{
Elvan Ceyhan
}
