% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxDelaunay.R
\name{rel.edge.std.triCM}
\alias{rel.edge.std.triCM}
\title{The index of the edge region in the standard equilateral triangle
that contains a point}
\usage{
rel.edge.std.triCM(p)
}
\arguments{
\item{p}{A 2D point for which \eqn{CM}-edge region it resides in is
to be determined in the
the standard equilateral triangle \eqn{T_e}.}
}
\value{
A \code{list} with three elements
\item{re}{Index of the \eqn{CM}-edge region that contains point,
\code{p} in the standard equilateral triangle \eqn{T_e}}
\item{tri}{The vertices of the standard equilateral triangle \eqn{T_e},
where row labels are \eqn{A}, \eqn{B}, and \eqn{C}
with edges are labeled as 3 for edge \eqn{AB},
1 for edge \eqn{BC}, and 2 for edge \eqn{AC}.}
\item{desc}{Description of the edge labels}
}
\description{
Returns the index of the edge
whose region contains point, \code{p}, in
the standard equilateral triangle
\eqn{T_e=T(A=(0,0),B=(1,0),C=(1/2,\sqrt{3}/2))}
with edge regions based on
center of mass \eqn{CM=(A+B+C)/3}.

Edges are labeled as 3 for edge \eqn{AB},
1 for edge \eqn{BC},
and 2 for edge \eqn{AC}.
If the point, \code{p}, is not inside \code{tri},
then the function yields \code{NA} as output.
Edge region 1 is the triangle \eqn{T(B,C,M)},
edge region 2 is \eqn{T(A,C,M)},
and edge region 3 is \eqn{T(A,B,M)}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012,ceyhan:arc-density-CS;textual}{pcds}).
}
\examples{
\donttest{
P<-c(.4,.2)
rel.edge.std.triCM(P)

A<-c(0,0); B<-c(1,0); C<-c(0.5,sqrt(3)/2);
Te<-rbind(A,B,C)
D1<-(B+C)/2; D2<-(A+C)/2; D3<-(A+B)/2;
CM<-(A+B+C)/3

n<-20  #try also n<-40
Xp<-runif.std.tri(n)$gen.points

re<-vector()
for (i in 1:n)
  re<-c(re,rel.edge.std.triCM(Xp[i,])$re)
re

Xlim<-range(Te[,1],Xp[,1])
Ylim<-range(Te[,2],Xp[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Te,asp=1,xlab="",ylab="",axes=TRUE,pch=".",xlim=Xlim+xd*c(-.01,.01),ylim=Ylim+yd*c(-.01,.01))
points(Xp,pch=".")
polygon(Te)
L<-Te; R<-matrix(rep(CM,3),ncol=2,byrow=TRUE)
segments(L[,1], L[,2], R[,1], R[,2], lty = 2)
text(Xp,labels=factor(re))

txt<-rbind(Te,CM)
xc<-txt[,1]+c(-.03,.03,.03,-.06)
yc<-txt[,2]+c(.02,.02,.02,.03)
txt.str<-c("A","B","C","CM")
text(xc,yc,txt.str)

p1<-(A+B+CM)/3
p2<-(B+C+CM)/3
p3<-(A+C+CM)/3

plot(Te,xlab="",ylab="",axes=TRUE,pch=".",xlim=Xlim+xd*c(-.01,.01),ylim=Ylim+yd*c(-.01,.01))
polygon(Te)
L<-Te; R<-matrix(rep(CM,3),ncol=2,byrow=TRUE)
segments(L[,1], L[,2], R[,1], R[,2], lty = 2)

txt<-rbind(Te,CM,p1,p2,p3)
xc<-txt[,1]+c(-.03,.03,.03,-.06,0,0,0)
yc<-txt[,2]+c(.02,.02,.02,.03,0,0,0)
txt.str<-c("A","B","C","CM","re=3","re=1","re=2")
text(xc,yc,txt.str)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rel.edge.triCM}}, \code{\link{rel.edge.tri}},
\code{\link{rel.edge.basic.triCM}}, \code{\link{rel.edge.basic.tri}},
and \code{\link{edge.reg.triCM}}
}
\author{
Elvan Ceyhan
}
