% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge3D.R
\name{plotPEregs.tetra}
\alias{plotPEregs.tetra}
\title{The plot of the Proportional Edge (PE) Proximity Regions for a 3D data set - one tetrahedron case}
\usage{
plotPEregs.tetra(
  Xp,
  th,
  r,
  M = "CM",
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  zlab = NULL,
  xlim = NULL,
  ylim = NULL,
  zlim = NULL,
  ...
)
}
\arguments{
\item{Xp}{A set of 3D points for which PE proximity regions are constructed.}

\item{th}{A \eqn{4 \times 3} matrix with each row representing a vertex of the tetrahedron.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{The center to be used in the construction of the vertex regions in the tetrahedron, \code{th}.
Currently it only takes \code{"CC"} for circumcenter and \code{"CM"} for center of mass; default=\code{"CM"}.}

\item{main}{An overall title for the plot (default=\code{NULL}).}

\item{xlab, ylab, zlab}{Titles for the \eqn{x}, \eqn{y}, and \eqn{z} axes, respectively (default=\code{NULL} for all).}

\item{xlim, ylim, zlim}{Two \code{numeric} vectors of length 2, giving the \eqn{x}-, \eqn{y}-, and \eqn{z}-coordinate ranges
(default=\code{NULL} for all).}

\item{\dots}{Additional \code{scatter3D} parameters.}
}
\value{
Plot of the PE proximity regions for points inside the tetrahedron \code{th}
(and just the points outside \code{th})
}
\description{
Plots the points in and outside of the tetrahedron \code{th} and also the PE proximity regions  (which are also
tetrahedrons) for points inside the tetrahedron \code{th}.

PE proximity regions are constructed with respect to
tetrahedron \code{th} with expansion parameter \eqn{r \ge 1} and vertex regions are based on the center \code{M} which is
circumcenter (\code{"CC"}) or center of mass (\code{"CM"}) of \code{th} with default=\code{"CM"}, so PE proximity regions are defined
only for points inside the tetrahedron \code{th}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010;textual}{pcds}).
}
\examples{
\donttest{
A<-c(0,0,0); B<-c(1,0,0); C<-c(1/2,sqrt(3)/2,0); D<-c(1/2,sqrt(3)/6,sqrt(6)/3)
set.seed(1)
tetra<-rbind(A,B,C,D)+matrix(runif(12,-.25,.25),ncol=3) #adding jitter to make it non-regular

n<-5  #try also n<-20
Xp<-runif.tetra(n,tetra)$g  #try also Xp[,1]<-Xp[,1]+1

M<-"CM"  #try also M<-"CC"
r<-1.5

plotPEregs.tetra(Xp,tetra,r) #uses the default M="CM"
plotPEregs.tetra(Xp,tetra,r,M="CC")

plotPEregs.tetra(Xp[1,],tetra,r)  #uses the default M="CM"
plotPEregs.tetra(Xp[1,],tetra,r,M)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotPEregs.std.tetra}}, \code{\link{plotPEregs.tri}} and \code{\link{plotPEregs.int}}
}
\author{
Elvan Ceyhan
}
