% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge1D.R
\name{IarcPEmid.int}
\alias{IarcPEmid.int}
\title{The indicator for the presence of an arc from a point to another for Proportional Edge
Proximity Catch Digraphs (PE-PCDs) - middle interval case}
\usage{
IarcPEmid.int(p1, x2, int, r, c = 0.5, rv = NULL)
}
\arguments{
\item{p1, x2}{1D points; \eqn{p_1} is the point for which the proximity region, \eqn{N_{PE}(p_1,r,c)} is
constructed and \eqn{p_2} is the point which the function is checking whether its inside
\eqn{N_{PE}(p_1,r,c)} or not.}

\item{int}{A \code{vector} of two real numbers representing an interval.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \code{int}\eqn{=(a,b)}
with the default \code{c=.5}.
For the interval, \code{int}\eqn{=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}

\item{rv}{The index of the vertex region \eqn{p_1} resides, with default=\code{NULL}.}
}
\value{
\eqn{I(p_2 \in N_{PE}(p_1,r,c))} for points \eqn{p_1} and \eqn{p_2} that is, returns 1 if \eqn{p_2} is in \eqn{N_{PE}(p_1,r,c)},
returns 0 otherwise
}
\description{
Returns \eqn{I(p_2 \in N_{PE}(p_1,r,c))} for points \eqn{p_1} and \eqn{p_2}, that is, returns 1 if \eqn{p_2} is in \eqn{N_{PE}(p_1,r,c)}, returns 0
otherwise, where \eqn{N_{PE}(x,r,c)} is the PE proximity region for point \eqn{x} and is constructed with expansion
parameter \eqn{r \ge 1} and centrality parameter \eqn{c \in (0,1)} for the interval \eqn{(a,b)}.

PE proximity regions are defined with respect to the middle interval \code{int} and vertex regions are based
on the center associated with the centrality parameter \eqn{c \in (0,1)}. For the interval, \code{int}\eqn{=(a,b)}, the
parameterized center is \eqn{M_c=a+c(b-a)}. \code{rv} is the index of the vertex region \eqn{p_1} resides, with default=\code{NULL}.
If \eqn{p_1} and \eqn{p_2} are distinct and either of them are outside interval \code{int}, it returns 0,
but if they are identical, then it returns 1 regardless of their locations
(i.e., loops are allowed in the digraph).

See also (\insertCite{ceyhan:metrika-2012,ceyhan:revstat-2016;textual}{pcds}).
}
\examples{
c<-.4
r<-2
a<-0; b<-10; int<-c(a,b)

IarcPEmid.int(7,5,int,r,c)
IarcPEmid.int(1,3,int,r,c)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IarcPEend.int}}, \code{\link{IarcCSmid.int}}, and \code{\link{IarcCSend.int}}
}
\author{
Elvan Ceyhan
}
