% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfactor_interpret.R
\name{bfactor_interpret}
\alias{bfactor_interpret}
\title{Interpretation of Bayes factors}
\usage{
bfactor_interpret(bf)
}
\arguments{
\item{bf}{A numeric vector of non-negative values.}
}
\value{
Returns a character vector with the same {\link[base]{length}} as \code{bf}.
}
\description{
Quantify the strength of the evidence provided by the data to a model/hypothesis according to the Bayes factor interpretation scale suggested by \insertCite{jeffreys1961;textual}{pcal}.
}
\details{
Bayes factors are a summary of the evidence provided by the data to a model/hypothesis. \insertCite{jeffreys1961;textual}{pcal} suggested the interpretation of Bayes factors in half-units on the base 10 logarithmic scale, as indicated in the following table:\tabular{lll}{
   \strong{log10(Bayes factor)} \tab \strong{Bayes factor} \tab \strong{Evidence} \cr
   [-Inf, 0[ \tab [0, 1[ \tab Negative \cr
   [0, 0.5[ \tab [1, 3.2[ \tab Weak \cr
   [0.5, 1[ \tab [3.2, 10[ \tab Substantial \cr
   [1, 1.5[ \tab [10, 32[ \tab Strong \cr
   [1.5, 2[ \tab [32, 100[ \tab Very Strong \cr
   [2, +Inf[ \tab [100, +Inf[ \tab Decisive \cr
}


\code{bfactor_interpret} takes Bayes factors as input and returns the strength of the evidence in favor of the model/hypothesis in the numerator of the Bayes factors (usually the null hypothesis) according to the aforementioned table.

When comparing results with those from standard likelihood ratio tests, it is convenient to put the null hypothesis in the denominator of the Bayes factor so that \code{bfactor_interpret} returns the strength of the evidence against the null hypothesis. If \code{bf} was obtained with the null hypothesis on the numerator, one can use \code{bfactor_interpret(1/bf)} to obtain the strength of the evidence against the null hypothesis.
}
\examples{
# Interpretation of one Bayes factor
bfactor_interpret(1.5)

# Interpretation of many Bayes factors
bfactor_interpret(c(0.1, 1.2, 3.5, 13.9, 150))

# Application: chi-squared goodness-of-fit test.
# Strength of the evidence provided by the lower
# bound on the Bayes factor in favor of the null hypothesis:
x <- matrix(c(12, 15, 14, 15), ncol = 2)
bfactor_interpret(bcal(chisq.test(x)[["p.value"]]))

}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
\item \code{\link[pcal]{bfactor_interpret_kr}} for an alternative interpretation scale.
\item \code{\link[pcal]{bfactor_log_interpret}} and \code{\link[pcal]{bfactor_log_interpret_kr}} for the interpretation of the logarithms of Bayes factors.
\item \code{\link[pcal]{bfactor_to_prob}} to turn Bayes factors into posterior probabilities.
\item \code{\link[pcal]{bcal}} for a p-value calibration that returns lower bounds on Bayes factors in favor of point null hypotheses.
}
}
