% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_update_saml_provider}
\alias{iam_update_saml_provider}
\title{Updates the metadata document, SAML encryption settings, and private
keys for an existing SAML provider}
\usage{
iam_update_saml_provider(
  SAMLMetadataDocument = NULL,
  SAMLProviderArn,
  AssertionEncryptionMode = NULL,
  AddPrivateKey = NULL,
  RemovePrivateKey = NULL
)
}
\arguments{
\item{SAMLMetadataDocument}{An XML document generated by an identity provider (IdP) that supports
SAML 2.0. The document includes the issuer's name, expiration
information, and keys that can be used to validate the SAML
authentication response (assertions) that are received from the IdP. You
must generate the metadata document using the identity management
software that is used as your IdP.}

\item{SAMLProviderArn}{[required] The Amazon Resource Name (ARN) of the SAML provider to update.

For more information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{Amazon Web Services General Reference}.}

\item{AssertionEncryptionMode}{Specifies the encryption setting for the SAML provider.}

\item{AddPrivateKey}{Specifies the new private key from your external identity provider. The
private key must be a .pem file that uses AES-GCM or AES-CBC encryption
algorithm to decrypt SAML assertions.}

\item{RemovePrivateKey}{The Key ID of the private key to remove.}
}
\description{
Updates the metadata document, SAML encryption settings, and private keys for an existing SAML provider. To rotate private keys, add your new private key and then remove the old key in a separate request.

See \url{https://www.paws-r-sdk.com/docs/iam_update_saml_provider/} for full documentation.
}
\keyword{internal}
