% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkmanager_operations.R
\name{networkmanager_create_device}
\alias{networkmanager_create_device}
\title{Creates a new device in a global network}
\usage{
networkmanager_create_device(
  GlobalNetworkId,
  AWSLocation = NULL,
  Description = NULL,
  Type = NULL,
  Vendor = NULL,
  Model = NULL,
  SerialNumber = NULL,
  Location = NULL,
  SiteId = NULL,
  Tags = NULL
)
}
\arguments{
\item{GlobalNetworkId}{[required] The ID of the global network.}

\item{AWSLocation}{The Amazon Web Services location of the device, if applicable. For an
on-premises device, you can omit this parameter.}

\item{Description}{A description of the device.

Constraints: Maximum length of 256 characters.}

\item{Type}{The type of the device.}

\item{Vendor}{The vendor of the device.

Constraints: Maximum length of 128 characters.}

\item{Model}{The model of the device.

Constraints: Maximum length of 128 characters.}

\item{SerialNumber}{The serial number of the device.

Constraints: Maximum length of 128 characters.}

\item{Location}{The location of the device.}

\item{SiteId}{The ID of the site.}

\item{Tags}{The tags to apply to the resource during creation.}
}
\description{
Creates a new device in a global network. If you specify both a site ID and a location, the location of the site is used for visualization in the Network Manager console.

See \url{https://www.paws-r-sdk.com/docs/networkmanager_create_device/} for full documentation.
}
\keyword{internal}
