% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrockagent_operations.R
\name{bedrockagent_create_agent_alias}
\alias{bedrockagent_create_agent_alias}
\title{Creates an alias of an agent that can be used to deploy the agent}
\usage{
bedrockagent_create_agent_alias(
  agentAliasName,
  agentId,
  clientToken = NULL,
  description = NULL,
  routingConfiguration = NULL,
  tags = NULL
)
}
\arguments{
\item{agentAliasName}{[required] The name of the alias.}

\item{agentId}{[required] The unique identifier of the agent.}

\item{clientToken}{A unique, case-sensitive identifier to ensure that the API request
completes no more than one time. If this token matches a previous
request, Amazon Bedrock ignores the request, but does not return an
error. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}.}

\item{description}{A description of the alias of the agent.}

\item{routingConfiguration}{Contains details about the routing configuration of the alias.}

\item{tags}{Any tags that you want to attach to the alias of the agent.}
}
\description{
Creates an alias of an agent that can be used to deploy the agent.

See \url{https://www.paws-r-sdk.com/docs/bedrockagent_create_agent_alias/} for full documentation.
}
\keyword{internal}
