#' @title imageList
#' @description List of RasterStacks as returned by \code{makeList}.
#' @format A list of 5 \code{RasterStack} objects of Heliconius erato hydara dorsal forewings.
#' @examples
#' \dontrun{
#' data(imageList)
#' summary(imageList)
#' }
"imageList"

#' @title landmarkList
#' @description List of landmarks as returned by \code{makeList}.
#' @format A list of landmarks for 5 Heliconius erato hydara dorsal forewings.
#' @examples
#' \dontrun{
#' data(landmarkList)
#' summary(landmarkList)
#' }
"landmarkList"

#' @title landmarkArray
#' @description Array of landmarks as returned by \code{lanArray} and used by
#'    \code{link[Morpho]{procsym}}.
#' @format An array of landmarks for 5 Heliconius erato hydara dorsal forewings.
#' @examples
#' \dontrun{
#' data(landmarkArray)
#' summary(landmarkArray)
#' }
"landmarkArray"

#' @title rasterList_lanRGB
#' @description List of RasterLayers as returned by \code{patLanRGB}.
#' @format A list of RasterLayers including the red color pattern extracted from 5 Heliconius
#'     erato hydara dorsal forewings using \code{patLanRGB}.
#' @examples
#' \dontrun{
#' data(rasterList_lanRGB)
#' summary(rasterList_lanRGB)
#' }
"rasterList_lanRGB"

#' @title rasterList_lanK
#' @description List of RasterLayers as returned by \code{patLanK}.
#' @format A list of RasterLayers including the red color pattern extracted from 5 Heliconius
#'    erato hydara dorsal forewings using \code{patLanK}.
#' @examples
#' \dontrun{
#' data(rasterList_lanK)
#' summary(rasterList_lanL)
#' }
"rasterList_lanK"

#' @title rasterList_regRGB
#' @description List of RasterLayers as returned by \code{patRegRGB}.
#' @format A list of RasterLayers including the red color pattern extracted from 5 Heliconius
#'    erato hydara dorsal forewings using \code{patRegRGB}.
#' @examples
#' \dontrun{
#' data(rasterList_regRGB)
#' summary(rasterList_regRGB)
#' }
"rasterList_regRGB"

#' @title rasterList_regK
#' @description List of RasterLayers as returned by \code{patRegK}.
#' @format A list of RasterLayers including the red color pattern extracted from 5 Heliconius
#'    erato hydara dorsal forewings using \code{patRegK}.
#' @examples
#' \dontrun{
#' data(rasterList_regK)
#' summary(rasterList_regK)
#' }
"rasterList_regK"
