% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\name{sokalSneath1}
\alias{sokalSneath1}
\alias{sokalSneath1,Partition,Partition-method}
\alias{sokalSneath1,PairCoefficients,missing-method}
\title{Sokal & Sneath Index 1}
\usage{
sokalSneath1(p, q)

\S4method{sokalSneath1}{Partition,Partition}(p, q)

\S4method{sokalSneath1}{PairCoefficients,missing}(p, q = NULL)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute the index 1 of Sokal and Sneath
\deqn{
\frac{1}{4} \left( \frac{N_{11}}{N_{21}} + \frac{N_{11}}{N_{12}} + 
\frac{N_{00}}{N'_{10}} + \frac{N_{00}}{N'_{01}} \right)
}
}
\section{Methods (by class)}{
\itemize{
\item \code{sokalSneath1(p = Partition, q = Partition)}: Compute given two partitions

\item \code{sokalSneath1(p = PairCoefficients, q = missing)}: Compute given the pair coefficients

}}
\examples{
isTRUE(all.equal(sokalSneath1(new("Partition", c(0, 0, 0, 1, 1)), 
                             new("Partition", c(0, 0, 1, 1, 1))), 7/12))

}
\references{
\insertRef{Sokal1963}{partitionComparison}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
