% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseLatex.R
\name{parseLatex_fn}
\alias{parseLatex_fn}
\alias{parseLatex}
\alias{LaTeX2}
\alias{LaTeX2item}
\title{Parse LaTeX code}
\usage{
parseLatex(
  text,
  verbose = FALSE,
  verbatim = c("verbatim", "verbatim*", "Sinput", "Soutput"),
  verb = "\\\\Sexpr",
  defcmd = c("\\\\newcommand", "\\\\renewcommand", "\\\\providecommand", "\\\\def",
    "\\\\let"),
  defenv = c("\\\\newenvironment", "\\\\renewenvironment"),
  catcodes = defaultCatcodes,
  recover = FALSE,
  showErrors = recover,
  ...
)
}
\arguments{
\item{text}{A character vector containing LaTeX source code.}

\item{verbose}{If \code{TRUE}, print debug error messages.}

\item{verbatim}{A character vector containing the names of \LaTeX environments holding verbatim text.}

\item{verb}{A character vector containing LaTeX macros that
should be assumed to hold verbatim text.}

\item{defcmd, defenv}{Character vectors of macros that
are assumed to define new macro commands or environments
respectively.  See the note below about some limitations.}

\item{catcodes}{A list or dataframe holding LaTeX "catcodes",
such as \link{defaultCatcodes}.}

\item{recover}{If \code{TRUE}, attempt to recover from errors and
continue parsing.  See Details below.}

\item{showErrors}{If \code{TRUE}, show errors after parsing.}

\item{...}{Additional parameters to pass to \link{showErrors}.}
}
\value{
\code{parseLatex} returns parsed Latex in a list with class \code{"LaTeX2"}.  Items in the list have class \code{"LaTeX2item"}.
}
\description{
The \code{parseLatex} function parses LaTeX source, producing a structured object.
}
\details{
Some versions of LaTeX such as \code{pdflatex} only handle ASCII
inputs, while others such as \code{xelatex} allow Unicode input.
\code{parseLatex} allows Unicode input.

During processing of LaTeX input, an interpreter can change
the handling of characters as it goes, using the \verb{\\catcode} macro
or others such as \verb{\\makeatletter}.  However, \code{parseLatex()} is purely
a parser, not an interpreter, so it can't do that, but
the user can change handling for the whole call using the
\code{catcodes} argument.

\code{catcodes} should be a list or dataframe
with at least two columns:
\itemize{
\item \code{char} should be a column of single characters.
\item \code{catcode} should be a column of integers in the range 0 to 15
giving the corresponding catcode.
}

During parsing, \code{parseLatex} will check these values first.
If the input character doesn't match anything, then it will
be categorized:
\itemize{
\item as a letter (catcode 11) using the ICU function
\code{u_hasBinaryProperty(c, UCHAR_ALPHABETIC)} (or \code{iswalpha(c)} on
Windows),
\item as a control
character (catcode 15) if its code point is less than 32,
\item as "other" (catcode 12) otherwise.
}

When \code{recover = TRUE}, the parser will mark each error
in the output, and attempt to continue parsing.  This
may lead to a cascade of errors, but will sometimes
help in locating the first error.  The section of text
related to the error will be marked as an item with
tag \code{ERROR}.
}
\section{\code{defcmd} limitations}{
The LaTeX defining commands have fairly simple syntax, but
\verb{\\def} and \verb{\\let} from plain Tex have quite variable syntax
and \code{parseLatex()} does not attempt to handle it all.  Stick
with simple syntax like \verb{\\def\\bea\{\\begin\{eqnarray\}\}} and
it should work.
}

\examples{
parsed <- parseLatex(r"(fran\c{c}ais)")
parsed
}
\seealso{
LaTeX2, LaTeX2item
}
