% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balance_panel.R
\name{has_gaps}
\alias{has_gaps}
\title{Check if panel data has gaps}
\usage{
has_gaps(data)
}
\arguments{
\item{data}{A \code{panel_data} frame.}
}
\value{
A logical value. \code{TRUE} if there are gaps, \code{FALSE} otherwise.
}
\description{
This function checks whether a \code{\link[=panel_data]{panel_data()}} object has implicit gaps
(missing rows for some entity-wave combinations).
}
\examples{
data("WageData")
wages <- panel_data(WageData, id = id, wave = t)
has_gaps(wages)  # FALSE (complete data)

# Create data with gaps
wages_gaps <- wages[wages$t != 3 | wages$id != wages$id[1], ]
has_gaps(wages_gaps)  # TRUE

}
\seealso{
\code{\link[=scan_gaps]{scan_gaps()}}, \code{\link[=balance_panel]{balance_panel()}}
}
