% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{specific<-}
\alias{specific<-}
\title{Set unit-specific parameters of a panelPomp object}
\usage{
specific(object) <- value
}
\arguments{
\item{object}{an object that contains unit-specific parameters.}

\item{value}{a numeric matrix with column names matching the names of the
\code{unit_objects} slot, and row names matching the names of the unit-specific
parameters. Alternatively, this can be a named vector following the naming
convention \verb{<parameter>[<unit_name>]}.}
}
\description{
This function is used to set the unit-specific parameters of a
panel pomp object.
}
\examples{
# set parameters in list form
prw <- panelRandomWalk(U = 4)
new_pars <- matrix(c(1, 1, 3, 2), nrow = 1)
dimnames(new_pars) <- list(param = "X.0", unit = c("rw1", "rw2", "rw3", "rw4"))
specific(prw) <- new_pars
}
\seealso{
\link{panelPomp_methods}
}
\author{
Jesse Wheeler
}
\keyword{internal}
