% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basics.R
\name{sub.paleoTS}
\alias{sub.paleoTS}
\title{Subsample a paleontological time-series}
\usage{
sub.paleoTS(y, ok = NULL, k = 0.1, reset.time = TRUE)
}
\arguments{
\item{y}{a \code{paleoTS} object}

\item{ok}{a logical vector, \code{TRUE} for populations to retain}

\item{k}{proportion of samples to retain, with the samples chosen randomly}

\item{reset.time}{if TRUE, resets the time so that the first population time is zero}
}
\value{
the sub-sampled \code{paleoTS} object
}
\description{
Subsampling is done according to the supplied logical vector or,
if none is supplied, as a proportion of samples, randomly chosen.
}
\examples{
x <- sim.GRW(ns=20)
plot(x)
xs1 <- sub.paleoTS(x, k = 0.5)
plot(xs1, add = TRUE, col="green")
keep <- rep(c(TRUE, FALSE), 10)
xs2 <- sub.paleoTS(x, ok = keep)
plot(xs2, add = TRUE, col = "red")
}
