% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairing.R
\name{alternate_pair_order}
\alias{alternate_pair_order}
\title{Deterministically alternate sample order in pairs}
\usage{
alternate_pair_order(pairs)
}
\arguments{
\item{pairs}{A tibble or data frame with columns \code{ID1}, \code{text1},
\code{ID2}, and \code{text2}.}
}
\value{
A tibble identical to \code{pairs} except that rows 2, 4, 6, ...
have \code{ID1}/\code{text1} and \code{ID2}/\code{text2} swapped.
}
\description{
This helper takes a table of paired writing samples (with columns
\code{ID1}, \code{text1}, \code{ID2}, and \code{text2}) and reverses the sample order for
every second row (rows 2, 4, 6, ...). This provides a perfectly balanced
reversal pattern without the randomness of \code{randomize_pair_order()}.
}
\details{
This is useful when you want a fixed 50/50 mix of original and reversed
pairs for bias control, benchmarking, or debugging, without relying on
the random number generator or seeds.
}
\examples{
data("example_writing_samples")
pairs <- make_pairs(example_writing_samples)

pairs_alt <- alternate_pair_order(pairs)

head(pairs[, c("ID1", "ID2")])
head(pairs_alt[, c("ID1", "ID2")])

}
