% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2dii.data.R
\docType{data}
\name{increasing_or_decreasing}
\alias{increasing_or_decreasing}
\title{Determine if a technology is increasing or decreasing}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 20 rows and 3 columns.
}
\usage{
increasing_or_decreasing
}
\description{
This dataset provides a simple lookup table to determine if a technology is
meant to increase or decrease to align with a scenario that predicts a less
than 2 degree temperature rise.
}
\section{Definitions}{


\itemize{
\item \code{increasing_or_decreasing} (character): If the technology is increasing or decreasing, as defined by the Paris-aligned IEA scenarios., * \code{sector} (character): The sector to which the technology belongs., * \code{technology} (character): The technology sub-category within the sector.
}

}

\examples{
head(increasing_or_decreasing)
}
\seealso{
Other datasets: 
\code{\link{gics_classification}},
\code{\link{isic_classification}},
\code{\link{iso_codes}},
\code{\link{nace_classification}},
\code{\link{naics_classification}},
\code{\link{palette_colours}},
\code{\link{psic_classification}},
\code{\link{region_isos}},
\code{\link{scenario_colours}},
\code{\link{sector_classifications}},
\code{\link{sector_colours}},
\code{\link{sic_classification}},
\code{\link{technology_colours}}
}
\concept{datasets}
\keyword{datasets}
