% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2dii.plot.R
\name{prep_techmix}
\alias{prep_techmix}
\title{Prepare data for plotting technology mix}
\usage{
prep_techmix(
  data,
  convert_label = identity,
  span_5yr = FALSE,
  convert_tech_label = identity
)
}
\arguments{
\item{data}{A data frame. Requirements:
\itemize{
\item The structure must be like \link[r2dii.plot]{market_share_demo}.
\item The following columns must have a single value: \code{sector}, \code{region},
\code{scenario_source}.
\item The column \code{metric} must have a portfolio (e.g. "projected"), a benchmark
(e.g. "corporate_economy"), and a single \code{scenario} (e.g. "target_sds").
\item (Optional) If present, the column \code{label} is used for data labels.
\item (Optional) If present, the column \code{label_tech} is used for technology
labels.
}}

\item{convert_label}{A symbol. The unquoted name of a function to apply to y-axis labels. For example:
\itemize{
\item To convert labels to uppercase use \code{convert_label = toupper}.
\item To get the default behavior of \code{qplot_techmix} use \code{convert_label = recode_metric_techmix}.
}}

\item{span_5yr}{Logical. Use \code{TRUE} to restrict the time span to 5 years from
the start year (the default behavior of \code{qplot_techmix()}), or use
\code{FALSE} to impose no restriction.}

\item{convert_tech_label}{A symbol. The unquoted name of a function to apply
to technology legend labels. For example, to convert labels to uppercase
use \code{convert_tech_label = toupper}. To get the default behavior of
\code{qplot_techmix()} use \code{convert_tech_label = spell_out_technology}.}
}
\value{
A data-frame ready to be plotted using \code{plot_techmix()}.
}
\description{
Prepare data for plotting technology mix
}
\examples{
# `data` must meet documented "Requirements"
data <- subset(
  market_share_demo,
  scenario_source == "demo_2020" &
    sector == "power" &
    region == "global" &
    metric \%in\% c("projected", "corporate_economy", "target_sds")
)

prep_techmix(data)
}
\seealso{
Other plotting functions: 
\code{\link{plot_emission_intensity}()},
\code{\link{plot_techmix}()},
\code{\link{plot_trajectory}()},
\code{\link{prep_emission_intensity}()},
\code{\link{prep_trajectory}()},
\code{\link{qplot_emission_intensity}()},
\code{\link{qplot_techmix}()},
\code{\link{qplot_trajectory}()},
\code{\link{recode_metric_techmix}()},
\code{\link{recode_metric_trajectory}()},
\code{\link{scale_colour_r2dii}()},
\code{\link{scale_colour_r2dii_sector}()},
\code{\link{scale_colour_r2dii_tech}()},
\code{\link{scale_fill_r2dii}()},
\code{\link{scale_fill_r2dii_sector}()},
\code{\link{scale_fill_r2dii_tech}()},
\code{\link{spell_out_technology}()},
\code{\link{theme_2dii}()},
\code{\link{to_title}()}
}
\concept{plotting functions}
