% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgrn.R
\name{pGRN}
\alias{pGRN}
\title{pGRN: creates gene regulatory network based on single cell pseudotime information}
\usage{
pGRN(
  expression_matrix,
  pseudotime_list,
  method = "DTW",
  slide_window_size = 20,
  slide_step_size = 10,
  centrality_degree_mod = "out",
  components_mod = "weak",
  network_min_genes = 10,
  quantile_cutoff = 5,
  order = 1,
  cores = 1
)
}
\arguments{
\item{expression_matrix}{expression matrix data}

\item{pseudotime_list}{list of pseudotime}

\item{method}{method for GRN construction: DTW, granger}

\item{slide_window_size}{sliding window size}

\item{slide_step_size}{sliding window step size}

\item{centrality_degree_mod}{(for DTW method) mode of centrality degree for popularity calculation}

\item{components_mod}{(for DTW method) mode of sub-network extraction methods (weak or strong)}

\item{network_min_genes}{minimal number of gene elements required for extracted sub-networks}

\item{quantile_cutoff}{an integer value (1-99) for quantile cutoff}

\item{order}{(for granger method) integer specifying the order of lags to include in the auxiliary regression}

\item{cores}{number of cores for parallel computing}
}
\value{
a list of tabl_graph objects
}
\description{
Given single cell matrix and pseudotime, construct gene regulatory network (GRN)
}
\examples{
example_data <- pGRNDB
expression_matrix <- example_data[["expression"]]
pseudotime_list <- example_data[["ptime"]]$PseudoTime

# try DTW method
nets <- pGRN(expression_matrix,
             pseudotime_list, 
             method= "DTW",
             quantile_cutoff=50,
             cores=1)
plot_network(nets[[1]])

# plot the network interactively
plot_network_i(nets[[1]])

}
