% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_C.R
\name{estimate_C_binary}
\alias{estimate_C_binary}
\title{Estimate constraint constant C for binary data}
\usage{
estimate_C_binary(X, qmax = 8, safety = 1.5, eps = 1e-12, radius = 1)
}
\arguments{
\item{X}{n x p binary data matrix (0/1 values)}

\item{qmax}{Rank for truncated SVD (default 8)}

\item{safety}{Safety parameter for conservative estimation (default 1.5)}

\item{eps}{Small constant to avoid logit divergence when p=0 or p=1 (default 1e-12)}

\item{radius}{Radius for cross-window smoothing (default 1)}
}
\value{
A list containing:
  \item{radius}{Cross-window radius used}
  \item{qmax}{Truncation rank used}
  \item{safety}{Safety parameter applied}
  \item{C0}{Original maximum row norm}
  \item{C_est}{Final conservative estimate of C}
  \item{a_norms}{Row norms of factor matrix A}
  \item{b_norms}{Row norms of factor matrix B}
  \item{Mhat}{Logit-transformed matrix}
  \item{P_smooth}{Smoothed probability matrix}
  \item{N_counts}{Count of values in each smoothing window}
}
\description{
Data-driven estimation of the constraint constant C for binary data
             using cross-window smoothing and empirical logit transformation.
}
\details{
The function performs the following steps:
1. Applies cross-window smoothing to estimate probabilities
2. Performs empirical logit transformation with smoothing
3. Computes truncated SVD of the transformed matrix
4. Constructs matrices A and B and calculates row norms
5. Estimates C as the maximum norm times safety parameter

The cross-window smoothing helps stabilize probability estimates,
especially for sparse binary data.
}
