% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_slides.R
\name{gs_png_url}
\alias{gs_png_url}
\alias{get_slide_page}
\alias{gs_png_download}
\alias{include_slide}
\title{Get Google Slide PNG URL}
\usage{
gs_png_url(url)

get_slide_page(url)

gs_png_download(url, output_dir = ".", overwrite = TRUE)

include_slide(
  url,
  output_dir = knitr::opts_chunk$get("fig.path"),
  overwrite = TRUE,
  ...
)
}
\arguments{
\item{url}{URL to Google Slide}

\item{output_dir}{path to output png}

\item{overwrite}{should the slide PNG be overwritten?}

\item{...}{for \code{include_slide}, options passed to
[knitr::include_graphics()]}
}
\value{
A character vector of URLs
}
\description{
Get Google Slide PNG URL
}
\examples{
url <- paste0(
  "https://docs.google.com/presentation/d/",
  "12DPZgPteQBwgal6kSPP58zhPhjZ7QSPZLe3NkA8M3eo/edit",
  "#slide=id.gc8648f14c3_0_397&t=4"
)
id <- get_slide_id(url)
gs_png_url(url)
}
