% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github_handling.R
\name{get_pages_url}
\alias{get_pages_url}
\title{Retrieve pages url for a repo}
\usage{
get_pages_url(repo_name, token = NULL, verbose = FALSE, keep_json = FALSE)
}
\arguments{
\item{repo_name}{The full name of the repo to get chapters from. e.g. 'jhudsl/OTTR_Template'}

\item{token}{If private repositories are to be retrieved, a github personal
access token needs to be supplied. Run `authorize("github")` to set this.}

\item{verbose}{TRUE/FALSE do you want more progress messages?}

\item{keep_json}{verbose TRUE/FALSE keep the json file locally?}
}
\value{
a data frame with the repository with the following columns:
data_level, data_path, chapt_name, url, repository name
}
\description{
Given an repository on GitHub, retrieve the pages URL for it.
}
\examples{
\dontrun{

usethis::create_github_token()

get_pages_url("jhudsl/Documentation_and_Usability")
}
}
