% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spell_check.R
\name{check_spelling}
\alias{check_spelling}
\title{Check spelling of all md, rmd, and qmd files}
\usage{
check_spelling(
  path = ".",
  output_dir = "check_reports",
  resources_dir = "resources",
  file_pattern = "md$"
)
}
\arguments{
\item{path}{path to the bookdown or quarto course repository, must have a
`.github` folder which will be used to establish the top of the repo.}

\item{output_dir}{A relative file path to the folder (existing or not) that the
output check file should be saved to. Default is "check_reports"}

\item{resources_dir}{A relative file path to the folder (existing or not) that the
dictionary.txt file and exclude_files.txt will be found. Default is "resources".
If no dictionary.txt file and exclude_files.txt files are found, we will download one.}

\item{file_pattern}{A file pattern should we be looking for for the files whose
spelling should be tested. Default is "md$". Regex interpreted.}
}
\value{
A file will be saved that lists the broken URLs will be saved to the specified output_dir.
}
\description{
Check spelling of all md, rmd, and qmd files
}
\examples{
\dontrun{

rmd_dir <- setup_ottr_template(dir = ".", type = "rmd", render = FALSE)

check_spelling(rmd_dir)

# If there are broken URLs they will be printed in a list at "check_reports/url_checks.tsv"

qmd_dir <- setup_ottr_template(dir = ".", type = "quarto", render = FALSE)

check_spelling(qmd_dir)
}
}
