% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{is_logging_enabled}
\alias{is_logging_enabled}
\title{Check whether OpenTelemetry logging is active}
\usage{
is_logging_enabled(severity = "info", logger = NULL)
}
\arguments{
\item{severity}{Check if logs are emitted at this severity level.}

\item{logger}{Logger object (\link{otel_logger}), or a logger name, the
instrumentation scope, to pass to \code{\link[=get_logger]{get_logger()}}.}
}
\value{
\code{TRUE} is OpenTelemetry logging is active, \code{FALSE} otherwise.
}
\description{
This is useful for avoiding computation when logging is inactive.
}
\details{
It calls \code{\link[=get_logger]{get_logger()}} with \code{name} and then it calls the logger's
\verb{$is_enabled()} method.
}
\examples{
fun <- function() {
  if (otel::is_logging_enabled()) {
    xattr <- calculate_some_extra_attributes()
    otel::log("Starting fun", attributes = xattr)
  }
  # ...
}
}
\seealso{
Other OpenTelemetry logs API: 
\code{\link{log}()},
\code{\link{log_severity_levels}}
}
\concept{OpenTelemetry logs API}
