% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordregr.R
\name{ordregr}
\alias{ordregr}
\title{Fit a proportional odds model for ordinal data}
\usage{
ordregr(
  y,
  nc = NULL,
  Xcal = Xcal,
  descending = FALSE,
  prior = list(mean = NULL, Prec = NULL),
  theta0 = NULL,
  ci.level = 0.95
)
}
\arguments{
\item{y}{Vector containing the ordinal response (coded using integers in 1:nc).}

\item{nc}{(optional) Maximum value of \code{y}.}

\item{Xcal}{Design matrix (excluding intercept columns).}

\item{descending}{Logical indicating if the odds of the response taking a value in the upper scale should be preferred over values in the lower scale.}

\item{prior}{(optional) List giving the 'mean' and 'Prec'(ision) of the regression parameters.}

\item{theta0}{(Optional) Vector containing starting values for the regression parameters.}

\item{ci.level}{Confidence levels of the computed credible intervals for the regression parameters.}
}
\value{
An object of class \link{ordregr.object}.
}
\description{
Fit a proportional odds model for ordinal data
}
\examples{
library(ordgam)
data(freehmsData)
Xcal = with(freehmsData, cbind(gndr,eduyrs,age))
mod = ordregr(y=freehmsData$freehms, Xcal=Xcal, descending=TRUE)
print(mod)

}
\references{
Lambert, P. and Gressani, 0. (2023) Penalty parameter selection and asymmetry corrections
to Laplace approximations in Bayesian P-splines models. Statistical Modelling. <doi:10.1177/1471082X231181173>. Preprint: <arXiv:2210.01668>.
}
\seealso{
\code{\link{ordgam}}, \code{\link{ordregr.object}}.
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
