% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.R
\name{riskCurves}
\alias{riskCurves}
\title{Marker-by-treatment predictiveness curves plot}
\usage{
riskCurves(x0E, x0Eb, x1E, x1Eb, ylab = "Predicted risk of event",
  xlab = "Empirical cumulative distribution function of the marker",
  main = "Marker-by-treatment predictiveness curves")
}
\arguments{
\item{x0E}{a numeric vector of the marker values for patients in the reference arm that developed the event.}

\item{x0Eb}{a numeric vector of the marker values for patients in the reference arm that did not develop the event.}

\item{x1E}{a numeric vector of the marker values for patients in the innovative arm that developed the event.}

\item{x1Eb}{a numeric vector of the marker values for patients in the innovative arm that did not develop the event.}

\item{ylab}{label of the Y-axis.}

\item{xlab}{label of the X-axis.}

\item{main}{title of the graph.}
}
\value{
None
}
\description{
This function plots the marker-by-treatment predictiveness curves for treatment selection markers, corresponding to the risk of event in each treatment arm in function of the cumulative distribution of the marker.
}
\details{
The function uses regression splines to plot the marker-by-treatment predictiveness curves. This graph may be used to check graphically the strength of the marker-by-treatment interaction, and to know whether low values of the marker are associated with a better response of the reference treatment (this information is needed in the \code{trtSelThresh} function).
}
\section{References}{

Janes, H, Pepe, MS, Bossuyt, PM, and Barlow, WE. Measuring the performance of markers for guiding treatment decisions. \emph{Annals of Internal Medicine}. 2011; 154(4): 253-259.
}

\examples{
x0E <- rnorm(100, 2, 1)
x0Eb <- rnorm(100, 4, 1)
x1E <- rnorm(100, 4, 1)
x1Eb <- rnorm(100, 2, 1)
riskCurves(x0E, x0Eb, x1E, x1Eb)
}
\seealso{
\code{\link[mgcv]{gam}} for more details about regression splines.
}
