% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdf.R
\docType{methods}
\name{cdf}
\alias{cdf}
\alias{cdf,normalDist-method}
\alias{cdf.normalDist}
\alias{cdf,logNormalDist-method}
\alias{cdf.logNormalDist}
\alias{cdf,gammaDist-method}
\alias{cdf.gammaDist}
\alias{cdf,studentDist-method}
\alias{cdf.studentDist}
\alias{cdf,logisticDist-method}
\alias{cdf.logisticDist}
\alias{cdf,compoundEvtRefDist-method}
\alias{cdf.compoundEvtRefDist}
\alias{cdf,compoundNoEvtRefDist-method}
\alias{cdf.compoundNoEvtRefDist}
\alias{cdf,compoundEvtInnovDist-method}
\alias{cdf.compoundEvtInnovDist}
\alias{cdf,compoundNoEvtInnovDist-method}
\alias{cdf.compoundNoEvtInnovDist}
\title{Cumulative distribution function of a specified distribution}
\usage{
cdf(object)

\S4method{cdf}{normalDist}(object)

\S4method{cdf}{logNormalDist}(object)

\S4method{cdf}{gammaDist}(object)

\S4method{cdf}{studentDist}(object)

\S4method{cdf}{logisticDist}(object)

\S4method{cdf}{compoundEvtRefDist}(object)

\S4method{cdf}{compoundNoEvtRefDist}(object)

\S4method{cdf}{compoundEvtInnovDist}(object)

\S4method{cdf}{compoundNoEvtInnovDist}(object)
}
\arguments{
\item{object}{Any S4 object for which a \code{cdf} method is defined. Should match with the definition of an S4 distribution object as defined in the \code{optimalThreshold} package.}
}
\value{
Returns the cumulative distribution function of the specified distribution.
}
\description{
The \code{cdf} function returns the cumulative distribution function relative to the S4 object passed in its argument. See details to know on what kind of S4 objects this function could be applied.
}
\details{
This method can be applied to the S4 distribution objects that are supported in the \code{optimalThreshold} package: \code{normalDist}, \code{logNormalDist}, \code{gammaDist}, \code{studentDist}, \code{logisticDist}, and \code{userDefinedDist}. These methods are applied internally, and you have no need to use it outside of the main functions \code{trtSelThresh} and \code{diagThresh}. 
\itemize{
\item Normal distribution: the \code{cdf} method applied to a \code{normalDist} object is simply the \code{pnorm} function (see help on this function to have more details).
\item Log-normal distribution: the \code{cdf} method applied to a \code{logNormalDist} object is simply the \code{plnorm} function (see help on this function to have more details).
\item Gamma distribution: the \code{cdf} method applied to a \code{gammaDist} object is simply the \code{pgamma} function (see help on this function to have more details).
\item Scaled t distribution: the scaled t distribution with \code{df} = n, \code{mu} = \eqn{\mu}, and \code{sd} = \eqn{\sigma} has density:
\deqn{f(x)=(\Gamma((n+1)/2)/(\sqrt{n\pi}\Gamma(n/2))(1+((x-\mu)/\sigma)^2/n)^-((n+1)/2))/\sigma}
\item Logistic distribution: the \code{cdf} method applied to a \code{logisticDist} object is simply the \code{plogis} function (see help on this function to have more details).
\item User-defined distribution: the \code{cdf} method applied to a \code{userDefinedDist} object is simply the cumulative distribution function provided by the user when fitting a user-defined distribution with the \code{fit} function.
}
The S4 objects \code{compoundEvtRefDist}, \code{compoundNoEvtRefDist}, \code{compoundEvtInnovDist}, and \code{compoundNoEvtInnovDist} are created internally. The \code{cdf} function applied to these objects is defined dynamically depending on what types of distribution are fitted. The definition of the \code{cdf} function relies on the expression of the randomization constraint of a clinical trial that enforces the distribution of the marker in each treatment arm to be identical (see References for more details).
}
\section{References}{

Blangero, Y, Rabilloud, M, Ecochard, R, and Subtil, F. A Bayesian method to estimate the optimal threshold of a marker used to select patients' treatment. \emph{Statistical Methods in Medical Research}. 2019.
}

\seealso{
\code{\link[optimalThreshold]{trtSelThresh}}, \code{\link[optimalThreshold]{diagThresh}}, \code{\link[stats]{pnorm}}, \code{\link[stats]{plnorm}}, \code{\link[stats]{pgamma}}, \code{\link[stats]{plogis}}, \code{\link[optimalThreshold]{fit}}.
}
