% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataPreparation.R
\name{dataPreparation}
\alias{dataPreparation}
\title{Transform data into the expected format}
\usage{
dataPreparation(dat, uncertainty = "SE", expVAL = "mean")
}
\arguments{
\item{dat}{Data frame or tibble in the format of the \code{\link{exampleData}}.
Please refer to the \href{https://github.com/Forest-Economics-Goettingen/optimLanduse/}{GitHub project page}
for more details.}

\item{uncertainty}{Indicates the column name of the uncertainty measure.
Typical is "SE" for standard
error or "SD" for standard deviation.}

\item{expVAL}{Indicates the column name of the expected value.}
}
\value{
A formatted coefficients table with land-use options and indicator values ready for initialization via \code{\link{initScenario}}.
}
\description{
The input data must suit the specific expected optimLanduse format prior to
initialization and optimization. This function
provides the possibility to easily transform data from the commonly used form
of the exemplary data
\code{\link{exampleData}} into the expected format. Please consider that the application of this function
is not mandatory and in most cases not required. Best practice is to
transform your data yourself into the expected format. Detailed information
about the expected format and possible data processing can be found on the
\href{https://github.com/Forest-Economics-Goettingen/optimLanduse/}{GitHub project page}.
Note that incomplete rows, which include NA-values will be deleted
and an error message will be thrown.
}
\examples{
require(readxl)
dat <- read_xlsx(exampleData("exampleGosling_dataPrep.xlsx"), col_names = TRUE)
dat <- dataPreparation(dat, uncertainty = "sd", expVAL = "mean")
}
\references{
Gosling, E., Reith, E., Knoke, T. et al. Exploring farmer perceptions of agroforestry via multi-objective optimisation:
a test application in Eastern Panama. Agroforest Syst 94, 2003–2020 (2020). https://doi.org/10.1007/s10457-020-00519-0
}
