% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argument_types.R
\name{GeoJson}
\alias{GeoJson}
\title{GeoJson}
\value{
Object of \code{\link[R6:R6Class]{R6::R6Class()}} representing an object in GeoJson.
}
\description{
Inheriting from \link{Argument} in order to represent a GeoJson object. This class represents geospatial features.
Allowed values are either a list directly convertible into a valid GeoJson or polygon features of type 'sf' or 'sfc'
from package 'sf'. The current implementation follows the data representation of 'sf' - meaning that coordinate order is
XY (e.g. if CRS84 is used then lon/lat is the default order).
}
\details{
As GeoJSON is defined in \href{https://datatracker.ietf.org/doc/html/rfc7946}{RFC7946} the coordinate reference system is
\code{urn:ogc:def:crs:OGC::CRS84}, which uses a longitude, latitude ordering of the coordinates.
}
\seealso{
\link{Array}, \link{Integer}, \link{EPSGCode}, \link{String}, \link{Number},
\link{Date}, \link{DataCube}, \link{ProcessGraphArgument},
\link{ProcessGraphParameter}, \link{OutputFormatOptions}, \link{GeoJson},
\link{Boolean}, \link{DateTime}, \link{Time}, \link{BoundingBox}, \link{Kernel},
\link{TemporalInterval}, \link{TemporalIntervals}, \link{CollectionId}, \link{OutputFormat},
\link{AnyOf}, \link{ProjDefinition}, \link{UdfCodeArgument}, \link{UdfRuntimeArgument} and
\link{UdfRuntimeVersionArgument}, \link{MetadataFilter}
}
