% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.session.R
\name{opal.session_events}
\alias{opal.session_events}
\title{Get the events associated to the R session}
\usage{
opal.session_events(opal)
}
\arguments{
\item{opal}{Opal object.}
}
\value{
A data frame.
}
\description{
The remote R session logs events in its process of creation. Each event has a 
the current state of the R session, a date and a message reported by the R server.
Fails if the session does not exist.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.session(o, wait = TRUE)
opal.session_events(o)
opal.logout(o)
}
}
\seealso{
Other session functions: 
\code{\link{opal.session}()},
\code{\link{opal.session_delete}()},
\code{\link{opal.session_exists}()},
\code{\link{opal.session_get}()},
\code{\link{opal.session_running}()}
}
\concept{session functions}
