% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{onehot}
\alias{onehot}
\title{Onehot encode a data.frame}
\usage{
onehot(data, stringsAsFactors = FALSE, addNA = FALSE, max_levels = 10)
}
\arguments{
\item{data}{data.frame to convert factors into onehot encoded columns}

\item{stringsAsFactors}{if TRUE, converts character vectors to factors}

\item{addNA}{if TRUE, adds NA to factors as a level}

\item{max_levels}{maximum number of levels to onehot encode per factor
variable. Factors with levels exceeding this number will be skipped.}
}
\value{
a \code{onehot} object descrbing how to transform the data
}
\description{
Onehot encode a data.frame
}
\examples{
data(iris)
encoder <- onehot(iris)

## add NAs to factors
encoder <- onehot(iris, addNA=TRUE)

## Convert character fields to factrs
encoder <- onehot(iris, stringsAsFactors=TRUE)

## limit which factors are onehot encoded
encoder <- onehot(iris, max_levels=5)
}
