% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columns.R
\name{settingsColumns}
\alias{settingsColumns}
\title{Identify settings columns of a \verb{<summarised_result>}}
\usage{
settingsColumns(result, metadata = FALSE)
}
\arguments{
\item{result}{A \verb{<summarised_result>}.}

\item{metadata}{Whether to include metadata columns in settings or not.}
}
\value{
Vector with names of the settings columns
}
\description{
Identifies and returns the columns of the settings table
obtained by using \code{settings()} in a \verb{<summarised_result>} object.
}
\examples{
{
  library(dplyr)
  library(omopgenerics)

  x <- tibble(
    "result_id" = as.integer(c(1, 2)),
    "cdm_name" = c("cprd", "eunomia"),
    "group_name" = "cohort_name",
    "group_level" = "my_cohort",
    "strata_name" = "sex",
    "strata_level" = "male",
    "variable_name" = "Age group",
    "variable_level" = "10 to 50",
    "estimate_name" = "count",
    "estimate_type" = "numeric",
    "estimate_value" = "5",
    "additional_name" = "overall",
    "additional_level" = "overall"
  ) |>
    newSummarisedResult(settings = tibble(
      "result_id" = c(1, 2), "custom" = c("A", "B")
    ))

  x

  x |> settingsColumns()
}
}
