% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naRows.r
\name{naRows}
\alias{naRows}
\title{Index of rows in a data frame or matrix that contain at least one \code{NA}}
\usage{
naRows(x, inf = FALSE, inverse = FALSE)
}
\arguments{
\item{x}{Data frame or matrix.}

\item{inf}{Logical, if \code{TRUE} then also return row numbers of rows in which at least one element is \code{Inf} or \code{-Inf}. The default is \code{FALSE}.}

\item{inverse}{Logical, if \code{TRUE} then return row numbers of rows that \emph{do not} have \code{NA}s (and possibly \code{Inf} or \code{-Inf}).  The default is \code{FALSE}.}
}
\value{
Integer vector.
}
\description{
This function returns the row number of any row in a data frame or matrix that has at least one \code{NA}. This is the same as \code{which(!complete.cases(x))}.
}
\examples{
x <- data.frame(a=1:5, b=c(1, 2, NA, 4, 5), c=c('a', 'b', 'c', 'd', NA))
naRows(x)
}
