% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windrose.R
\name{plot,windrose-method}
\alias{plot,windrose-method}
\alias{plot.windrose}
\title{Plot a windrose Object}
\usage{
\S4method{plot}{windrose}(
  x,
  type = c("count", "mean", "median", "fivenum"),
  convention = c("meteorological", "oceanographic"),
  mgp = getOption("oceMgp"),
  mar = c(mgp[1], mgp[1], 1 + mgp[1], mgp[1]),
  col,
  debug = getOption("oceDebug")
)
}
\arguments{
\item{x}{a \linkS4class{windrose} object.}

\item{type}{The thing to be plotted, either the number of counts in the angle
interval, the mean of the values in the interval, the median of the values, or
a \code{\link[=fivenum]{fivenum()}} representation of the values.}

\item{convention}{String indicating whether to use meteorological convention or
oceanographic convention for the arrows that emanate from the centre of the
rose.  In meteorological convection, an arrow emanates towards the right on
the diagram if the wind is from the east; in oceanographic convention, such an
arrow indicates flow \emph{to} the east.}

\item{mgp}{Three-element numerical vector to use for \code{\link{par}}\code{(mgp)}, and also
for \code{\link{par}}\code{(mar)}, computed from this.  The default is tighter than the R
default, in order to use more space for the data and less for the axes.}

\item{mar}{Four-element numerical vector to be used with \code{\link{par}}\code{("mar")}.}

\item{col}{Optional list of colors to use.  If not set, the colors will be
\code{c("red", "pink", "blue", "lightgray")}.  For the first three types of
plot, the first color in this list is used to fill in the rose, the third is
used for the petals of the rose, and the fourth is used for grid lines. For the
\code{"fivenum"} type, the region from the lower hinge to the first quartile is
coloured pink, the region from the first quartile to the third quartile
is coloured red, and the region from the third quartile to the upper hinge
is coloured pink.  Then the median is drawn in black.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\description{
Plot a \linkS4class{windrose} object.
}
\examples{
library(oce)
set.seed(1234)
theta <- seq(0, 360, 0.25)
x <- 1 + cos(pi / 180 * theta) + rnorm(theta)
y <- sin(pi / 180 * theta) + rnorm(theta)
wr <- as.windrose(x, y)
plot(wr)
plot(wr, type = "fivenum")

}
\seealso{
Other functions that plot oce data: 
\code{\link{download.amsr}()},
\code{\link{plot,adp-method}},
\code{\link{plot,adv-method}},
\code{\link{plot,amsr-method}},
\code{\link{plot,argo-method}},
\code{\link{plot,bremen-method}},
\code{\link{plot,cm-method}},
\code{\link{plot,coastline-method}},
\code{\link{plot,ctd-method}},
\code{\link{plot,gps-method}},
\code{\link{plot,ladp-method}},
\code{\link{plot,landsat-method}},
\code{\link{plot,lisst-method}},
\code{\link{plot,lobo-method}},
\code{\link{plot,met-method}},
\code{\link{plot,odf-method}},
\code{\link{plot,rsk-method}},
\code{\link{plot,satellite-method}},
\code{\link{plot,sealevel-method}},
\code{\link{plot,section-method}},
\code{\link{plot,tidem-method}},
\code{\link{plot,topo-method}},
\code{\link{plot,xbt-method}},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{tidem-class}}

Other things related to windrose data: 
\code{\link{[[,windrose-method}},
\code{\link{[[<-,windrose-method}},
\code{\link{as.windrose}()},
\code{\link{summary,windrose-method}},
\code{\link{windrose-class}}
}
\author{
Dan Kelley
}
\concept{functions that plot oce data}
\concept{things related to windrose data}
