% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/densityLegend.R
\name{scatterplotDL}
\alias{scatterplotDL}
\title{Plot a base-graphics scatterplot with accompanying density legend}
\usage{
scatterplotDL(x, y, colorVar, colorPalette, side = "right",
  proportion = 0.3, legendTitle = NULL, ...)
}
\arguments{
\item{x}{the x coordinates to be handed to plot()}

\item{y}{the y coordinates of points in the plot()}

\item{colorVar}{the numeric vector of values used to color the points}

\item{colorPalette}{a color palette. If 'colorPalette' contains, for example,
6 colors, then the values of colorVar will be split and assigned to these 6
colors}

\item{side}{the side of the plot to put the density legend on ("left", "right",
"top", or "bottom")}

\item{proportion}{the proportion of the plot (from 0 to 1) to allocate to the
density legend (defaults to 0.3)}

\item{legendTitle}{string for labelling the density legend}

\item{...}{additional parameters to be passed to plot()}
}
\value{
none, plot is added to device
}
\description{
Plot a base-graphics scatterplot with accompanying density legend
}
\examples{
library(ggplot2)
library(RColorBrewer)
colorPalette <- brewer.pal(9, "YlOrRd")[4:9]
scatterplotDL(x = mtcars$mpg, y = mtcars$wt, colorVar = mtcars$hp,
legendTitle = "Horse Power", colorPalette = colorPalette, pch = 19,
		xlab = "MPG (miles per gallon)", ylab = "Weight (tonnes)",
		main = "MPG by Weight in Cars \\n Colored by Horse Power")
}
\author{
Jason Waddell
}

