% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/densityLegend.R
\name{densityLegend}
\alias{densityLegend}
\title{Create a colored density legend for visually representing the distribution of
a color variable on a plot}
\usage{
densityLegend(x, colorPalette, colorBreaks, side = "right", main = NULL)
}
\arguments{
\item{x}{a numeric vector used to create the density trace}

\item{colorPalette}{a vector of color values}

\item{colorBreaks}{a vector of cutoff values for the color regions}

\item{side}{the side of the plot to place the desntiy legend}

\item{main}{the main title for the density legend (optional, recommended to
use a title that describes x}
}
\value{
none, graphics are added to the current device
}
\description{
Create a colored density legend for visually representing the distribution of
a color variable on a plot
}
\examples{
library(ggplot2)
library(RColorBrewer)

# subset the data object
dsub <- subset(diamonds, x > 5 & x < 6 & y > 5 & y < 6)
dsub <- dsub[-which(dsub$z > 4), ]
dsub <- dsub[-which(dsub$z < 3), ]

# define color pallette, color vector and color region breaks
colorPalette <- brewer.pal(9, "Blues")[4:9]
colorObj <- splitColorVar(colorVar = dsub$z, colorPalette)
colorVec <- colorObj$colorVec
breaks <- colorObj$breaks

# plot the data
prepLegend(side = "right", proportion = 0.3)
oaTemplate(xlim = range(dsub$x), ylim = range(dsub$y),
		main = "Diamond Length by Width \\n Colored by Depth",
		xlab = "Length (mm)", ylab = "Width (mm)")
points(x = dsub$x, y = dsub$y, col = colorVec, pch = 19, cex = 0.6)

# add the legend
densityLegend(x = dsub$z, colorPalette = colorPalette, side = "right",
		main = "Diamond Depth", colorBreaks = breaks)
}
\author{
Jason Waddell
}

