% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mid_term_future.R
\name{mid_term_future}
\alias{mid_term_future}
\title{Generate future mid-term demand predictions}
\usage{
mid_term_future(
  midterm_predictions,
  end_year,
  Tref = 18,
  data_directory = tempdir(),
  midterm_model = NULL,
  verbose = FALSE
)
}
\arguments{
\item{midterm_predictions}{Dataframe or list. Generated by \code{\link{mid_term_lm}}. Either the prediction dataframe or the complete output list can be used.
If the full list is supplied the function will extract the necessary models automatically.}

\item{end_year}{Integer. Specifies the final year for which future predictions will be generated.}

\item{Tref}{Numeric. Reference temperature as basis for the calculation of cooling and heating days.}

\item{data_directory}{The path to the directory where the data will be saved and where the function will look for
the mid-term model from \code{\link{mid_term_lm}}. The default is set to a temporary directory.}

\item{midterm_model}{The mid-term seasonality model from \code{\link{mid_term_lm}}. Only needs to be specified if the model
is not in the data directory.}

\item{verbose}{A boolean value indicating if you want the generated plot to be shown (set to TRUE if yes).}
}
\value{
A list with the extended initial dataframe with the future predictions for the mid term model. And the plot with the midterm seasonality future forecast.
The dataset and the plot are saved in the respective folder for the country.
\describe{
\item{midterm_future_predictions}{A dataframe with the input and prediction data for the future mid-term seasonality.}
\item{midterm_future_plot}{A plot with the prediction results.}
}
}
\description{
This function extends the mid-term demand predictions generated by \code{\link{mid_term_lm}} until a specified future year.
The unknown temperature-based covariates for future days are obtained by averaging over the past 3 years of the dataset.
The function also produces and saves visualizations of the actual and the predicted demand over the training, test, and future periods.
}
\examples{
example_midterm_future_predictions <- mid_term_future(example_midterm_predictions,
  end_year = 2028, Tref = 18
)
}
\seealso{
See also function \code{\link{long_term_future}} and \code{\link{short_term_future}} for the other prediction models.
}
