% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC_normal.R
\name{posterior_prob_normal}
\alias{posterior_prob_normal}
\title{Forward-Backward Algorithm to Calculate the Posterior Probabilities of Hidden States in Normal Model}
\usage{
posterior_prob_normal(data, pi, mat_T, means, sdev)
}
\arguments{
\item{data}{(numeric) normal data}

\item{pi}{(numeric) prior probability of states}

\item{mat_T}{(matrix) transition probability matrix}

\item{means}{(numeric) vector with prior means}

\item{sdev}{(numeric) prior standard deviation}
}
\value{
List with the following elements: 
\itemize{
  \item \code{F}: auxiliary forward variables
  \item \code{B}: auxiliary backward variables
  \item \code{s}: weights
}
}
\description{
Forward-Backward Algorithm to Calculate the Posterior Probabilities of Hidden States in Normal Model
}
\details{
Please see \href{https://static-content.springer.com/esm/art\%3A10.1186\%2Fs12859-024-05751-4/MediaObjects/12859_2024_5751_MOESM1_ESM.pdf}{supplementary information} at \doi{10.1186/s12859-024-05751-4} for more details on the algorithm.
}
\examples{
prior_mat <- rbind(c(1-0.05, 0.05, 0),
                  c(0.05, 1-0.1, 0.05),
                  c(0, 0.05, 1-0.05))

prior_means <- c(-0.1, 0.0, 0.1)
prior_sd  <- sqrt(0.1)
L <- 100

# Simulate HMM model based on normal data based on prior information
sim_data_normal <- hmm_simulate_normal_data(L = L,
                                            mat_T = prior_mat,
                                            means = prior_means,
                                            sigma = prior_sd)
pi <- sim_data_normal$pi
# pi <- get_pi(prior_mat)
hmm_norm_data <- sim_data_normal$data

# Calculate posterior probabilities of hidden states
post_prob <-  posterior_prob_normal(data = hmm_norm_data,
                                    pi = pi,
                                    mat_T = prior_mat,
                                    means = prior_means,
                                    sdev = prior_sd)
str(post_prob)
}
