% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_accuracy.R
\name{get_accuracy}
\alias{get_accuracy}
\title{Calculate the accuracy of outbreak reconstruction}
\usage{
get_accuracy(out, true_tree)
}
\arguments{
\item{out}{An object of class \code{outbreaker_chains}.}

\item{true_tree}{A data frame with the true transmission tree, including 'from' and 'to' columns.}
}
\value{
A numeric vector of accuracy values for each posterior tree.
}
\description{
Accuracy is defined as the proportion of correctly assigned ancestries across the posterior sample.
}
\examples{
true_tree <- data.frame(from = as.character(outbreaker2::fake_outbreak$ances), to = linelist$id)
get_accuracy(out, true_tree)
}
