% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_chain.R
\name{filter_chain}
\alias{filter_chain}
\title{Filter chain by parameter threshold}
\usage{
filter_chain(out, param, thresh, comparator = "<=", target = "alpha")
}
\arguments{
\item{out}{A data frame of class \code{outbreaker_chains}.}

\item{param}{Name of the parameter prefix (e.g. \code{"kappa"}).}

\item{thresh}{Numeric threshold.}

\item{comparator}{A string comparator: one of \code{"<="}, \code{">="}, \code{"<"}, \code{">"}, \code{"=="}.}

\item{target}{Name of the target prefix to mask (e.g. \code{"alpha"}).}
}
\value{
An \code{outbreaker_chains} data frame with \code{target_*} entries set to \code{NA}
wherever \code{param_*} \code{comparator} \code{thresh} is \code{FALSE}.
}
\description{
Mask target columns whenever a parameter column fails a threshold test.
}
\examples{
# Mask alpha_i whenever kappa_i > 1
filter_chain(out, param = "kappa", thresh = 1, comparator = "<=", target = "alpha")

}
