% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotatorExt.R
\name{annotatorExt}
\alias{annotatorExt}
\title{Retrieve annotator's "ext" resource}
\usage{
annotatorExt(labbcat.url, annotator.id, resource, parameters = NULL)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance.}

\item{annotator.id}{ID of the annotator to interrogate.}

\item{resource}{The name of the file to retrieve or instance method (function) to
invoke. Possible values for this depend on the specific annotator being interrogated.}

\item{parameters}{Optional list of ordered parameters for the instance method (function).}
}
\value{
The resource requested.
}
\description{
Retrieve a given resource from an annotator's "ext" web app. Annotators are modules
that perform different annotation tasks, and can optionally implement functionality for
providing extra data or extending functionality in an annotator-specific way. If the
annotator implements an "ext" web app, it can provide resources and implement a
mechanism for iterrogating the annotator. This function provides a mechanism for
accessing these resources via R.
}
\examples{
\dontrun{
## Get the version of the currently installed LabelMapper annotator:
annotatorExt(labbcat.url, "LabelMapper", "getVersion")

## Get the summary of the segment to speakerDependentPhone mapping
## implemented by the LabelMapper annotator:
summaryJson <- annotatorExt(labbcat.url,
              "LabelMapper", "summarizeMapping", list("segment","speakerDependentPhone"))
summary <- jsonlite::fromJSON(summaryJson)
}

}
