% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcriptUpload.R
\name{transcriptUpload}
\alias{transcriptUpload}
\title{Upload a transcript file and associated media files.}
\usage{
transcriptUpload(labbcat.url, transcript, media = NULL, merge = FALSE)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{transcript}{The path to the transcript to upload.}

\item{media}{The path to the media to upload, if any.}

\item{merge}{Whether the upload corresponds to updates to an existing transcript
(TRUE) or a new transcript (FALSE).}
}
\value{
A named list with members:
\itemize{
\item \emph{id} The unique identifier to use for this upload when subsequently calling
transcriptUploadParameters()
\item \emph{parameters} A list of named lists representing the parameters that require values
to be passed into transcriptUploadParameters().
The parameters returned may include both information required by the format
deserializer (e.g. mappings from tiers to LaBB-CAT layers) and also general
information required by LaBB-CAT (e.g. the corpus, episode, and type of the
transcript).
Each parameter returned is a dict that may contain the following attributes:
- "name" - The name that should be used when specifying the value for the
parameter when calling transcriptUploadParameters()
- "label" - A label for the parameter intended for display to the user.
- "hint" - A description of the purpose of the parameter, for display to the user.
- "type" - The type of the parameter, e.g. "String", "Double", "Integer", "Boolean".
- "required" - True if the value must be specified, False if it is optional.
- "value" - A default value for the parameter.
- "possibleValues" - A list of possible values, if the possibilities are limited
to a finite set.
The required parameters may include both information required by the format
deserializer  (e.g. mappings from tiers to LaBB-CAT layers) and also general
information required by LaBB-CAT, such as:
- "labbcat_corpus" - The corpus the new transcript(s) belong(s) to.
- "labbcat_episode" - The episode the new transcript(s) belong(s) to.
- "labbcat_transcript_type" - The transcript type for the new transcript(s).
- "labbcat_generate" - Whether to re-regenerate automated annotation layers or not.
}
}
\description{
Uploading files is the first stage in adding or modifying a transcript to LaBB-CAT.
The second stage is transcriptUploadParameters()
}
\details{
\emph{NB} Using transcriptUpload and transcriptUploadParameters is an alternative to using
newTranscript or updateTranscript.

For this function to work, the credentials used to connect to the server must have at
least 'edit' access.
}
\examples{
\dontrun{
## Get attributes for new transcript
corpus <- getCorpusIds(labbcat.url)[1]
transcript.type.layer <- getLayer(labbcat.url, "transcript_type")
transcript.type <- transcript.type.layer$validLabels[[1]]

## upload transcript and its media
result <- transcriptUpload(labbcat.url, "my-transcript.eaf", "my-transcript.wav", FALSE)

## use the default parameter values
parameterValues <- list()
for(p in 1:length(parameters$name)) parameterValues[parameters$name[p]] <- parameters$value[p]

## set the upload parameters to finalise the upload
transcript.id <- transcriptUploadParameters(labbcat.url, result$id, parameterValues)
}
}
\seealso{
\itemize{
\item \link{transcriptUploadParameters}
\item \link{transcriptUploadDelete}
\item \link{newTranscript}
\item \link{updateTranscript}
}
}
\keyword{management}
\keyword{transcript}
