% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_EB_E2p_EB_E.R
\name{n_EB_E2p_EB_E}
\alias{n_EB_E2p_EB_E}
\title{Convert n-vector to cartesian position vector in meters}
\usage{
n_EB_E2p_EB_E(n_EB_E, z_EB = 0, a = 6378137, f = 1/298.257223563)
}
\arguments{
\item{n_EB_E}{n-vector of position B, decomposed in E (3x1 vector) (no unit)}

\item{z_EB}{Depth of system B, relative to the ellipsoid (z_EB = -height) (m, default 0)}

\item{a}{Semi-major axis of the Earth ellipsoid (m, default [WGS-84] 6378137)}

\item{f}{Flattening of the Earth ellipsoid (no unit, default [WGS-84] 1/298.257223563)}
}
\value{
Cartesian position vector from E to B, decomposed in E (3x1 vector) (m)
}
\description{
The function converts the position of B (typically body) relative to E (typically Earth),
the n-vector \code{n_EB_E} to cartesian position vector ("ECEF-vector"), \code{p_EB_E},
in meters.
}
\details{
The calculation is exact, taking the ellipticity of the Earth into account.

It is also nonsingular as both n-vector and p-vector are nonsingular
(except for the center of the Earth).
The default ellipsoid model used is WGS-84, but other ellipsoids (or spheres) might be specified
via the optional parameters \code{a} and \code{f}.
}
\examples{
n_EB_E  <- lat_lon2n_E(rad(1), rad(2))
n_EB_E2p_EB_E(n_EB_E)

}
\references{
Kenneth Gade \href{https://www.navlab.net/Publications/A_Nonsingular_Horizontal_Position_Representation.pdf}{A Nonsingular Horizontal Position Representation}.
\emph{The Journal of Navigation}, Volume 63, Issue 03, pp 395-417, July 2010.
}
\seealso{
\code{\link{p_EB_E2n_EB_E}}, \code{\link{n_EA_E_and_p_AB_E2n_EB_E}} and
         \code{\link{n_EA_E_and_n_EB_E2p_AB_E}}.
}
